/*************************************************************************
  *
  * ADOBE CONFIDENTIAL
  * ___________________
  *
  *  Copyright 2024 Adobe Systems Incorporated
  *  All Rights Reserved.
  *
  * NOTICE:  All information contained herein is, and remains
  * the property of Adobe Systems Incorporated and its suppliers,
  * if any.  The intellectual and technical concepts contained
  * herein are proprietary to Adobe Systems Incorporated and its
  * suppliers and are protected by trade secret or copyright law.
  * Dissemination of this information or reproduction of this material
  * is strictly forbidden unless prior written permission is obtained
  * from Adobe Systems Incorporated.
  **************************************************************************/
 /*global $, Folder, app, File, COLOR, PatternType, PatternColor */
var PATTERN = {};

PATTERN.patternColorToData = function (patternColor) {
    if (!patternColor || patternColor.typename !== 'PatternColor' || !patternColor.pattern) {
        return null;
    }
    var pattern = patternColor.pattern;
    var scaleFactor = { scaleH: patternColor.scaleFactor[0], scaleV: patternColor.scaleFactor[1]};
    var reflect = patternColor.reflect || 0;
    var reflectAngle = patternColor.reflectAngle || 0;
    var rotation = patternColor.rotation || 0;
    var shearAngle = patternColor.shearAngle || 0;
    var shearAxis = patternColor.shearAxis || 0;
    var shiftDistance = patternColor.shiftDistance || 0;   
    var shiftAngle = patternColor.shiftAngle || 0;
    var matrix = patternColor.matrix;
    return [{
        shiftDist : shiftDistance,
        shiftAngle : shiftAngle,
        scaleFactor : scaleFactor,
        rotate : rotation,
        reflect : reflect,
        reflectAngle : reflectAngle,
        shearAngle : shearAngle,
        shearAxis : shearAxis,
        matrix : matrix
    }];
};